/*****************************************************/
/* Examples Program For "ET-ARM7 BASE LPC2106" Board */
/* Target MCU  : Philips ARM7-LPC2106                */
/*       	   : X-TAL : 19.6608 MHz                 */
/*             : Run Speed 58.9824MHz (With PLL)     */
/* Keil Editor : uVision3 V3.03a                     */
/* Compiler    : Keil CARM V2.50a		             */
/* Create By   : Eakachai Makarn (WWW.ETT.CO.TH)     */
/* Last Update : 17/April/2006                       */
/* Function    : Example Use Timer1 = PWM Mode       */
/*****************************************************/
// GPIO0.7  -> PWM2 = 1.0mS/20mS
// GPIO0.8  -> PWM4 = 1.5mS/20mS
// GPIO0.9  -> PWM6 = 2.0mS/20mS

#include <LPC210x.H> 	                                	// LPC2106 MPU Register

// Main Program Start Here //
int main(void)
{  
  // Initial Timer1 Pin Connect   
  PINSEL0 &= 0xFFFF3FFF; 		// 1111 1111 1111 1111 0011 1111 1111 1111 = Reset P0.7 Function 
  PINSEL0 |= 0x00008000; 		// 0000 0000 0000 0000 1000 0000 0000 0000 = P0.7 -> PWM2

  PINSEL0 &= 0xFFFCFFFF; 		// 1111 1111 1111 1100 1111 1111 1111 1111 = Reset P0.8 Function 
  PINSEL0 |= 0x00020000; 		// 0000 0000 0000 0010 0000 0000 0000 0000 = P0.8 -> PWM4

  PINSEL0 &= 0xFFF3FFFF; 		// 1111 1111 1111 0011 1111 1111 1111 1111 = Reset P0.9 Function
  PINSEL0 |= 0x00080000; 		// 0000 0000 0000 1000 0000 0000 0000 0000 = P0.9 -> PWM6
 
  //Initial PWM2 = Single Edge PWM
  // Set   Output PWM  By Match-0
  // Reset Output PWM2 By Match-2
  // Reset Output PWM4 By Match-4
  // Reset Output PWM6 By Match-6  
  PWMPR = 0; 												// Prescale = 1
  PWMPCR &= 0xFFFFFFFB;										// PWMSEL2 = "1" = PWM2 Single Edge Control
  PWMPCR &= 0xFFFFFFEF;										// PWMSEL4 = "1" = PWM4 Single Edge Control
  PWMPCR &= 0xFFFFFFBF;										// PWMSEL6 = "1" = PWM6 Single Edge Control
  PWMPCR |= 0x00000400;										// PWMENA2 = "1" = Enable PWM2
  PWMPCR |= 0x00001000;										// PWMENA4 = "1" = Enable PWM4
  PWMPCR |= 0x00004000;										// PWMENA6 = "1" = Enable PWM6
  PWMMCR = 0x00000002;										// On Match0 = Reset Counter  

  // Initial PWM Timing 
  // Timer Count PCLK (29.4912MHz)  
  // 1 Cycle Timer  = 33.90842 nS
  // -> 20 mS = 589824 Cycle (90000H)
  // -> 1.0mS = 29491.2 Cycle (7333H)
  // -> 1.5mS = 44236.8 Cycle (ACCDH)
  // -> 2.0mS = 58982.4 Cycle (E666H)
  PWMMR0 = 589824;											// Set PWM  = 20mS  (29.4912MHz)  
  PWMMR2 = 29491;											// Set PWM2 = 1.0mS	(29.4912MHz)
  PWMMR4 = 44236;											// Set PWM4 = 1.5mS	(29.4912MHz)
  PWMMR6 = 58982;											// Set PWM6 = 2.0mS	(29.4912MHz)

  PWMLER = 0x00000055;										// Enable Shadow Latch For Match 0,2,4,6  
  PWMTCR = 0x00000002;										// Reset Counter and Prescaler 
  PWMTCR = 0x00000009;										// Enable Counter and PWM + Release Counter From Reset

  // Now GPIO0.7 Generate PWM = 1.0mS
  //     GPIO0.8 Generate PWM = 1.5mS
  //     GPIO0.9 Generate PWM = 2.0mS
  while(1);													// Loop Continue  

}


